/********************************************************************************
 Author              : CAST (China Applications Support Team) 

 Date                : 4-25-2011

 File name           : AD9523Test.c

 Description         : Using ADuC7026 to control AD9523 in software SPI form through GPIO.
 					   Route VCXO to Channel0-channel3's divider then to OUT0-OUT3.

 Hardware plateform  : ADuC7026 	+ AD9523
********************************************************************************/
#include<ADuC7026.h>
#include"ADuC7026Driver.h"
#include"AD9523.h"

int main()
{
	unsigned char cstr[8] = {0,0,0,0,0,0,0,0};
	unsigned char regdata[8] = {0,0,0,0,0,0,0,0};
				 	
	ADuC7026_Initiate();
//----------------------------------------------------------------------------
	cstr[0] = SERIAL_DEFAULT | SDO_ACTIVE;
	WriteToAD9523ViaSpi(SERIAL_PORT_CONFIGURATION,cstr,1); // write instruction and data to selected registers

	cstr[0] = IO_UPDATE_EN;
	WriteToAD9523ViaSpi(IO_UPDATE,cstr,1);
	
	cstr[0] = 0x02;	   //vcxo out in form of single-end CMOS
	WriteToAD9523ViaSpi(INPUT_RECEIVER,cstr,1);
	cstr[0] = 0xF0;	
	WriteToAD9523ViaSpi(POWER_DOWN_CONTROL_BITS,cstr,1);
//---------------------------------------------------------
	cstr[0] = 0x8F;	//route vcxo to out0-out1
	WriteToAD9523ViaSpi(VCXO_OUTPUT_CHANNEL,cstr,1); 	
	
//------------------------------------------------------------------------	
	cstr[0] = 0x06;			// channel0-channel4 using single-end CMOS
	WriteToAD9523ViaSpi(CHANNEL_3_CTRL,cstr,1);
	WriteToAD9523ViaSpi(CHANNEL_2_CTRL,cstr,1);
	WriteToAD9523ViaSpi(CHANNEL_1_CTRL,cstr,1);
	WriteToAD9523ViaSpi(CHANNEL_0_CTRL,cstr,1);

//set divider to 1, output 122.8MHz
//	WriteToAD9523ViaSpi(CHANNEL_3_DIVI_BITS,0,1);
//	WriteToAD9523ViaSpi(CHANNEL_2_DIVI_BITS,0,1);
//	WriteToAD9523ViaSpi(CHANNEL_1_DIVI_BITS,0,1);
//	WriteToAD9523ViaSpi(CHANNEL_0_DIVI_BITS,0,1);
		
    cstr[0] = IO_UPDATE_EN;
	WriteToAD9523ViaSpi(IO_UPDATE,cstr,1);
	ReadFromAD9523ViaSpi(VCXO_OUTPUT_CHANNEL,regdata,2);
	
 	while(1)
    {;}

	return 0;

}
