/********************************************************************************
 Author              : CAST (China Applications Support Team) 

 Date                : 4-25-2011

 File name           : AD9523.c

 Description         : Using ADuC7026 to control AD9523 in software SPI form through GPIO

 Hardware plateform  : ADuC7026 	+ AD9523
********************************************************************************/
#include<ADuC7026.h>
#include"ADuC7026Driver.h"
#include"AD9523.h"


/********************************************************************************
Function that writes to the AD9523 via the SPI port.
********************************************************************************/

void WriteInstruction(unsigned short InsData)
{
	unsigned char i;
	
	//Write out the ControlWord
	
	for(i=0; i<16; i++)
	{	
		ADuC7026_OutputBit(AD9523_SCLK,0);
		
		if(0x8000 == (InsData & 0x8000))
		{
			ADuC7026_OutputBit(AD9523_SDIN,1);	  //Send one to SDIN pin
		}
		else
		{
			ADuC7026_OutputBit(AD9523_SDIN,0);	  //Send zero to SDIN pin
		}
		
		ADuC7026_OutputBit(AD9523_SCLK,1);
		
		InsData <<= 1;	//Rotate data
	}
		

}

void WriteData(unsigned char *pBuf, unsigned char N)
{

	unsigned char i,j;
	unsigned char TempData;
	//Write out the data 
	
	for(j=0; j<N; j++)
	{
		TempData = pBuf[j];
		
		for(i=0; i<8; i++)
		{	
			ADuC7026_OutputBit(AD9523_SCLK,0);

			if(0x80 == (TempData & 0x80))
			{
				ADuC7026_OutputBit(AD9523_SDIN,1);	  //Send one to SDIN pin
			}
			else
			{
				ADuC7026_OutputBit(AD9523_SDIN,0);	  //Send zero to SDIN pin
			}
		
			ADuC7026_OutputBit(AD9523_SCLK,1);
	
	    TempData <<= 1;	//Rotate data
		}
	}

}


/********************************************************************************
Function that read from the AD9523 via the SPI port.
********************************************************************************/


void ReadRegData(unsigned char *pBuf, unsigned char N) 
{
	unsigned char	 i,j;
	for(j=0; j<N; j++)
	{

		for(i=0; i<8; i++)
		{
		
			ADuC7026_OutputBit(AD9523_SCLK,1);
		
			ADuC7026_OutputBit(AD9523_SCLK,0);

			pBuf[j]<<=1;
			 
			pBuf[j] |= ADuC7026_InputBit(AD9523_SDOUT);			// P4.4->SDout
		}
		putchar(pBuf[j]);	//readback data of selected  Register,which can be seen using CommAssistant  
	}	
}

void WriteToAD9523ViaSpi(unsigned short RegAddress,unsigned char *RegData,unsigned char Num)
{
	//write instruction to selected register
	unsigned short insdata = 0;

	if(1==Num)
		insdata = WRITE | ONE_BYTE | RegAddress;
	else if(2==Num)
		insdata = WRITE | TWO_BYTE | RegAddress;
	else if(3==Num)
		insdata = WRITE | THREE_BYTE | RegAddress;
	else
		insdata = WRITE | STREAMING_MODE | RegAddress;	
		
	ADuC7026_OutputBit(AD9523_CS,0);
	Delay(1);
	WriteInstruction(insdata); 	
	WriteData(RegData,Num);
	ADuC7026_OutputBit(AD9523_CS,1);	  
}

void ReadFromAD9523ViaSpi(unsigned short RegAddress,unsigned char *RegData,unsigned char Num)	  
{
	unsigned char pBuffer[8]={0,0,0,0,0,0,0,0};
	unsigned char i;
	//write instruction to selected register
	unsigned short insdata = 0;

	if(1==Num)
		insdata = READ | ONE_BYTE | RegAddress;
	else if(2==Num)
		insdata = READ | TWO_BYTE | RegAddress;
	else if(3==Num)
		insdata = READ | THREE_BYTE | RegAddress;
	else
		insdata = READ | STREAMING_MODE | RegAddress;	

	ADuC7026_OutputBit(AD9523_CS,0);
	Delay(1);
	WriteInstruction(insdata); 	
	ReadRegData(pBuffer,Num);

	for(i=0;i<Num;i++)
	{
		RegData[i] = pBuffer[i];
	}
	
	ADuC7026_OutputBit(AD9523_CS,1);	  
}



