/********************************************************************************
 Author              : CAST (China Applications Support Team) 

 Date                : 4-25-2011

 File name           : ADuC7026Driver.c

 Description         : Using ADuC7026 to control AD9523 in software SPI form through GPIO

 Hardware plateform  : ADuC7026 	+ AD9523
********************************************************************************/
#include<ADuC7026.h>
#include"ADuC7026Driver.h"


void Delay(unsigned long int DelayTime)			  //delay function,Delay(1)=10us
{ 
	unsigned char i;

	while(DelayTime>0)
	{ 
		for(i=0;i<32;i++) {}
		DelayTime--;
	}
}

//GPIO Control
unsigned char ADuC7026_InputBit(unsigned char GPIONum)
{
	unsigned long int Temp;
	unsigned char Data;

	Temp=0xFFFFFFFF-(1<<((GPIONum&0x0F)+24));

	switch(GPIONum>>4)
	{
		case	0:
			GP0DAT&=Temp;
			Data=GP0DAT;		
			break;
		case	1:
			GP1DAT&=Temp;
			Data=GP1DAT;
			break;
		case	2:
			GP2DAT&=Temp;
			Data=GP2DAT;
			break;
		case	3:
			GP3DAT&=Temp;
			Data=GP3DAT;
			break;
		case	4:
			GP4DAT&=Temp;
			Data=GP4DAT;
			break;
	}
	if((Data&(1<<(GPIONum&0x0F)))==(1<<(GPIONum&0x0F)))
	{
		Data=1;
	}
	else
	{
		Data=0;
	}

	return Data;
}

void ADuC7026_OutputBit(unsigned char GPIONum, unsigned char Data)
{
	unsigned long int Temp;

	Temp=1<<(GPIONum&0x0F);



	switch(GPIONum>>4)
	{
		case	0:
			GP0DAT|=(Temp<<24);
			if(Data==0)
			{
				GP0CLR=(Temp<<16);
			}
			else
			{
				GP0SET=(Temp<<16);	
			}
			break;
		case	1:
			GP1DAT|=(Temp<<24);
			if(Data==0)
			{
				GP1CLR=(Temp<<16);
			}
			else
			{
				GP1SET=(Temp<<16);	
			}
			break;
		case	2:
			GP2DAT|=(Temp<<24);
			if(Data==0)
			{
				GP2CLR=(Temp<<16);
			}
			else
			{
				GP2SET=(Temp<<16);	
			}
			break;
		case	3:
			GP3DAT|=(Temp<<24);
			if(Data==0)
			{
				GP3CLR=(Temp<<16);
			}
			else
			{
				GP3SET=(Temp<<16);	
			}
			break;
		case	4:
			GP4DAT|=(Temp<<24);
			if(Data==0)
			{
				GP4CLR=(Temp<<16);
			}
			else
			{
				GP4SET=(Temp<<16);	
			}
			break;
	}
}

// The putchar() function in ARM is not OK for ADuC7026
// To use the printf() function, must rewrite the putchar() function 
void putchar(unsigned char ch) 
{

	COMTX=ch;	
	while(!(0x020==(COMSTA0 & 0x020)))	{;}	
//	return ch;

}

void PLL_Initiate()
{	//--------------------------------------------------------------------
	//41.78MHz
	POWKEY1 = 0x01;				//Start PLL setting,changeless
	POWCON=0x00;
	POWKEY2 = 0xF4;				//Finish PLL setting,changeless
}

void UART_Initiate()
{
/*
	// Setup tx & rx pins on P1.0 and P1.1
	GP1CON = 0x2211;				// I2C on P1.2 and P1.3	  Setup tx & rx pins on P1.0 and P1.1 for UART
 
	 // CD = 0 !		 
	COMCON0 = 0x80;					// Setting DLAB
   	COMDIV0 = 0x0B;					// Setting DIV0 and DIV1 to DL calculated
	COMDIV1 = 0x00;

   	COMCON0 = 0x07;					// Clearing DLAB
	// fractional divider
  	COMDIV2 = 0x883E;			  	// M=1
									// N=01101010101  =853
									// M+N/2048	 =1.4165
									//41.78MHz/(16*2*2^CD*DL*(M+N/2048))	 //CD=0  DL=0B=11
									//115.2Kbps  M+N/2048 =1.0303	M=1, N=	 62=0x3EH=000 0011 1110
									//comdiv2=0x883E
*/
	/*
	//Enable UART interrupt
	COMIEN0=0x03;					
	IRQEN |= UART_BIT;	
	*/


//Start setting up UART at 9600bps
	COMCON0 = 0x80;					// Setting DLAB

	COMDIV0 = 0x85;				//9600bps
   	COMDIV1 = 0x00;
   	COMCON0 = 0x07;					// Clearing DLAB			
	//Configure UART;
	GP1CON = 0x00000011;			//P1.0 as SIN,P1.1 as SOUT
	GP0CON = (GP0CON | 0x10000000);																		

}




void ADuC7026_Initiate(void)
{
	PLL_Initiate();
	UART_Initiate();
	ADuC7026_OutputBit(AD9523_CS,1);
}


/*    Function Pointers for Interrupts  */
tyVctHndlr    IRQ     = (tyVctHndlr)0x0;
tyVctHndlr    SWI     = (tyVctHndlr)0x0;
tyVctHndlr    FIQ     = (tyVctHndlr)0x0;
tyVctHndlr    UNDEF   = (tyVctHndlr)0x0;
tyVctHndlr    PABORT  = (tyVctHndlr)0x0;
tyVctHndlr    DABORT  = (tyVctHndlr)0x0;

void	IRQ_Handler   (void) __irq;
void	SWI_Handler   (void) __irq;
void	FIQ_Handler   (void) __irq;
void	Undef_Handler (void) __irq;
void	PAbt_Handler  (void) __irq;
void	DAbt_Handler  (void) __irq;

void	IRQ_Handler(void) __irq
{
	if ( *IRQ !=0x00)
	{
		IRQ();
	}
}

void	FIQ_Handler(void) __irq
{
	if ( *FIQ !=0x00)
	{
		FIQ();
	}
}

void	SWI_Handler(void) __irq
{
	if ( *SWI !=0x00)
	{
		SWI();
	}
}

void	Undef_Handler(void)__irq 
{
	if ( *UNDEF !=0x00)
	{
		UNDEF();
	}
}

void	PAbt_Handler(void) __irq
{
	if ( *PABORT !=0x00)
	{
		PABORT();
	}
}

void	DAbt_Handler(void) __irq
{
	if ( *DABORT !=0x00)
	{
		DABORT();
	}
}


