/********************************************************************************
 Author              : CAST (China Applications Support Team) 

 Date                : 4-25-2011

 File name           : AD9523.h

 Description         : Using ADuC7026 to control AD9523 in software SPI form through GPIO

 Hardware plateform  : ADuC7026 	+ AD9523
********************************************************************************/
#ifndef AD9523_H
#define AD9523_H

//------------------------------------
//functions' prototype
//------------------------------------

void WriteInstruction(unsigned short InsData);

void ReadRegData(unsigned char *pBuf, unsigned char N);
void WriteData(unsigned char *pBuf,unsigned char N);
void WriteToAD9523ViaSpi(unsigned short RegAddress,unsigned char *RegData,unsigned char Num);
//void ReadFromAD9523ViaSpi(unsigned short RegAddress,unsigned char *RegData,unsigned char Num);
void ReadFromAD9523ViaSpi(unsigned short RegAddress,unsigned char *RegData,unsigned char Num);


//---------------------------------------------------------------
//The format of the  16bit instruction word read as follows
// |R/W|W1|W0|A12=0|A11=0|A10=0|A9|A8|A7|A6|A5|A4|A3|A2|A1|A0|
//---------------------------------------------------------------


//READ OR WRITE
#define READ                      (0x01<<15)
#define WRITE                     (0x00<<15)

//BYTE TRANSFER COUNT
#define ONE_BYTE                   0x00
#define TWO_BYTE                  (0x01<<13)
#define THREE_BYTE                (0x10<<13)
#define STREAMING_MODE            (0x11<<13) 
//--------------------------
//REGISTERS' address
//--------------------------

//serial PORT configuration
#define SERIAL_PORT_CONFIGURATION 0x000
#define READ_BACK_CONTROL         0x004
#define EEPROM_CUSTOMER_L         0x005
#define EEPROM_CUSTOMER_H         0x006




//INPUT PLL
#define REF_A_DIVIDER_L           0x010
#define REF_A_DIVIDER_H           0x011
#define REF_B_DIVIDER_L           0x012
#define REF_B_DIVIDER_H           0x013
#define REF_TEST_DIVIDER          0x014
#define PLL1_FEEDBACK_DIVIDER_L   0x016
#define PLL1_FEEDBACK_DIVIDER_H   0x017
#define PLL1_CHARGE_PUMP          0x018
#define PLL1_CHARGE_PUMP_CONTROL2 0x019
#define INPUT_RECEIVER            0x01A

//OUTPUT PLL
#define PLL2_CHARGE_PUMP          0x0F0
#define PLL2_FEEDBACK_DIVIDER     0x0F1
#define PLL_CONTROL               0x0F2
#define VCO_CONTROL               0x0F3
#define VCO_DIVIDERS              0x0F4
#define LOOP_FILTER_CONTROL       0x0F5
#define PLL2_R2_DIVIDER           0x0F7

//CLOCK DISTRIBUTION
#define CHANNEL_0_CTRL 				       0x190
#define CHANNEL_0_DIVI_BITS                0x191
#define CHANNEL_0_DIVI_PHASE               0x192
#define CHANNEL_1_CTRL 		               0x193
#define CHANNEL_1_DIVI_BITS                0x194
#define CHANNEL_1_DIVI_PHASE               0x195
#define CHANNEL_2_CTRL 		               0x196
#define CHANNEL_2_DIVI_BITS                0x197
#define CHANNEL_2_DIVI_PHASE               0x198
#define CHANNEL_3_CTRL 		               0x199
#define CHANNEL_3_DIVI_BITS                0x19A
#define CHANNLE_3_DIVI_PHASE               0x19B
#define CHANNEL_4_CTRL 		               0x19C
#define CHANNEL_4_DIVI_BITS                0x19D
#define CHANNLE_4_DIVI_PHASE               0x19E
#define CHANNEL_5_CTRL 		               0x19F
#define CHANNEL_5_DIVI_BITS                0x1A0
#define CHANNLE_5_DIVI_PHASE               0x1A1
#define CHANNEL_6_CTRL 		               0x1A2
#define CHANNEL_6_DIVI_BITS                0x1A3
#define CHANNLE_6_DIVI_PHASE               0x1A4
#define CHANNEL_7_CTRL 		               0x1A5
#define CHANNEL_7_DIVI_BITS                0x1A6
#define CHANNLE_7_DIVI_PHASE               0x1A7
#define CHANNEL_8_CTRL 		               0x1A8
#define CHANNEL_8_DIVI_BITS                0x1A9
#define CHANNLE_8_DIVI_PHASE               0x1AA
#define CHANNEL_9_CTRL 		               0x1AB
#define CHANNEL_9_DIVI_BITS                0x1AC
#define CHANNLE_9_DIVI_PHASE               0x1AD
#define CHANNEL_10_CTRL 		           0x1AE
#define CHANNEL_10_DIVI_BITS               0x1AF
#define CHANNLE_10_DIVI_PHASE              0x1B0
#define CHANNEL_11_CTRL 	               0x1B1
#define CHANNEL_11_DIVI_BITS               0x1B2
#define CHANNLE_11_DIVI_PHASE              0x1B3
#define CHANNEL_12_CTRL 	               0x1B4
#define CHANNEL_12_DIVI_BITS               0x1B5
#define CHANNLE_12_DIVI_PHASE              0x1B6
#define CHANNEL_13_CTRL 	               0x1B7
#define CHANNEL_13_DIVI_BITS               0x1B8
#define CHANNLE_13_DIVI_PHASE              0x1B9
#define OUT_PLL_1                          0x1BA
#define VCXO_OUTPUT_CHANNEL                0x1BB

//READ BACK REGISTERS
#define READBACK_0                0x22C
#define READBACK_1                0x22D

//OTHER
#define STATUS_SIGNALS_0          0x230
#define STATUS_SIGNALS_1          0x231
#define POWER_DOWN_CONTROL_BITS   0x233
#define IO_UPDATE                 0x234

//EEPROM BUFFER
#define SPI_CONFIG_REGISTER         0xA00
#define SPI_SEGMENT_H               0xA01
#define SPI_SEGMENT_L               0xA02

#define READBACK_CONTROL_REGISTER   0xA03
#define READBACK_CONTROL_REGISTER_H 0xA04
#define READBACK_CONTROL_REGISTER_L 0xA05

#define PLL_SEGMENT                 0xA06
#define PLL_SEGMENT_H               0xA07
#define PLL_SEGMENT_L               0xA08

#define PECL_VCO_OUPUT_SEGMENT      0xA09
#define PECL_VCO_OUPUT_SEGMENT_H    0xA0A
#define PECL_VCO_OUPUT_SEGMENT_L    0xA0B

#define DIVIDER_SEGMENT             0xA0C
#define DIVIDER_SEGMENT_H           0xA0D
#define DIVIDER_SEGMENT_L           0xA0E

#define CLOCK_INPUT_REF_SEGMENT     0xA0F
#define CLOCK_INPUT_REF_SEGMENT_H   0xA10
#define CLOCK_INPUT_REF_SEGMENT_L   0xA11

#define OTHER_SEGMENT               0xA12
#define OTHER_SEGMENT_H             0xA13
#define OTHER_SEGMENT_L             0xA14
//#define IO_UPDATE                   0xA15
#define END_OF_DATA                 0xA16

//EEPROM CONTROL
#define ERRO_CHECKI                 0xB01

#define SDO_ACTIVE                   0x81
#define SERIAL_DEFAULT				 0x00

//INPUT PLL FUNCTION BITS
#define IPLL_CHARGE_PUMP_TRISTATE    0x80
#define ABP_EN                       0x10
#define REF_TEST_INPUT_ENABLE        0x80
#define REFB_DIFF_RECEIVER_ENABLE    0x40
#define REFA_DIFF_RECEIVER_ENABLE    0x20
#define REFB_MANUAL_CTRL_RECE_ENABLE 0x10
#define REFA_MANUAL_CTRL_RECE_ENABLE 0x08
#define MANUAL_PD_CTRL_ENABLE        0x04
#define EN_VCXO_NEG_SE_INPUT_RECE    0x02
#define EN_VCXO_DIFF_INPUT_RECE      0x01

#define BYPASS_REF_TEST_PATH_DIVI    0x80
#define BYPASS_FEEDBACK_DIVI         0x40
#define	BYPASS_ZERO_DELAY_FB_BUFFER  0x20
#define USE_VCXO_OUTPUT_FB_PLL       0x10
#define ZD_SE_NEG_INPUT_PIN_MODE     0x08
#define EN_ZD_DIFF_INPUT_MODE        0x04
#define REFB_SE_NEG_INPUT_PIN_MODE   0x02
#define REFA_SE_NEG_INPUT_PIN_MODE   0x01

#define EN_REFB_DIVI_INDEP_CTRL      0x80
#define VCXO_CTRL_VOLTAGE_REF_FAILS  0x40
#define EN_FAST_LOCK_MODE            0x20
#define BYPASS_REFB_PATH_DIVI        0x02
#define BYPASS_REFA_PATH_DIVI        0x01

//OUTPUT PLL FUNCTION BITS
#define OUTPUT_PLL_LOCK_DETECT            0x80
#define FREQ_DOUBLER_BAND                 0x40
#define EN_REF_FREQ_DOUBLER               0x20
#define EN_MANUAL_CTRL_ANTIBACKLASH_PULSE 0x10
#define OPLL_LOCKED_CTRL_SYNC_DISABLE     0x10
#define TREAT_REF_AS_VALID                0x08
#define FORCE_VCO_MIDPOINT_FREQ           0x04
#define VCO_CAL                           0x02
#define VCO_DIVI2_POWER_DOWN              0x40
#define VCO_DIVI1_POWER_DOWN              0x10

//CLOCK DISTRIBUTION FUNCTION BITS
#define INVERT_DIVI_OUTPUT                0x80
#define BLOCK_SYNC                        0x40
#define PWR_DWN_CHANNEL                   0x20
#define DIFF_MODE_PRE_DRIVER_STRENGTH     0x10
#define PLL1_VCXO_OUTPUT_DRIVER_CMOS_STRENGTH_STRONG  0x10

#define PLL1_OUTPUT_DRIVER_PWR_DWN        0x80
#define EN_CLOCK_VCXO_CH3                 0x08
#define EN_CLOCK_VCXO_CH2                 0x04
#define EN_CLOCK_VCXO_CH1                 0x02
#define EN_CLCOK_VCXO_CH0                 0x01

//OTHER FUNCTION BITS
#define EN_STATUS_EEPROM_AT_STATUS0_PIN   0x10
#define STATUS1_PIN_DIVI_ENABLE           0x08
#define STATUS0_PIN_DIVI_ENABLE           0x40
#define SYNC_DIVI_MANUAL_CTRL             0x01

#define SYNC_POWER_DOWN                   0x08
#define INPUT_PLL_PD                      0x04
#define OUTPUT_PLL_PD                     0x02
#define DIST_POWER_DOWN                   0x01

#define IO_UPDATE_EN                      0x01

//EEPROM CONTROL FUNCTION BITS
#define STATUS_EEPROM                     0x01
#define SOFT_EEPROM                       0x02
#define EN_WP                             0x01




































































#endif



